/* IBM_PROLOG_BEGIN_TAG                                                   */
/* This is an automatically generated prolog.                             */
/*                                                                        */
/*                                                                        */
/*                                                                        */
/* Licensed Materials - Property of IBM                                   */
/*                                                                        */
/* (C) COPYRIGHT International Business Machines Corp. 1998,2001          */
/* All Rights Reserved                                                    */
/*                                                                        */
/* US Government Users Restricted Rights - Use, duplication or            */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.      */
/*                                                                        */
/* IBM_PROLOG_END_TAG                                                     */
#ifndef _SAMPLE_PROVIDERTABLE_H
#define _SAMPLE_PROVIDERTABLE_H

static char *Sample_Providertable_sccsid = "@(#)51   1.3   src/rsct/pgs/samples/Sample_ProviderTable.h, gssamples, rsct_rori, roris01a 5/14/01 09:43:42";


#if !defined(_HAGSD_COPYRIGHT_H)
#define _HAGSD_COPYRIGHT_H
static char copyright[] = "Licensed Materials - Property of IBM\n\
(C) COPYRIGHT International Business Machines Corp. 1998,2001.\n\
All Rights Reserved.\n\
US Government Users Restricted Rights - Use, duplication or \n\
disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n";
#endif

/*********************************************************************/
/*
 * Name:  Sample_ProviderTable.h
 *
 * Build the sorted list of providers in the system, sorted by node
 * number.
 *
 * See Sample_Subscribe.C for more info.
 */
 /*********************************************************************/

#include "Sample_Subscribe.h"           // Standard includes.

class   Node;

#define MAX_NODE_NUMBER      4095

class   ProviderTable {
  public:

    ProviderTable(void);

    virtual ~ProviderTable(void);

  public:
    // Add a provider into the correct frame.  Return number of providers
    // in table.
    int         Add(short _instance,
                    short _node,
                    unsigned int *_IPaddr,
                    ha_gs_adapter_death_t *_death);

    // Print out the table.
    void        Print(void);

  private:

    Node       *providerTable[MAX_NODE_NUMBER + 1]; // Array of nodes.

    int         haveAlias;              // Any nodes have alias information?
    int         haveDeath;              // Any nodes have death information?

    int         count;                  // Total number of providers.
    short       highestNode;            // Highest node number received.
};

#endif  /* _SAMPLE_PROVIDERTABLE_H */
